/*
 * Routines for running in standalone mode
 */

#include "fma_myri.h"
#include "fma_myri_packet.h"

#define FMA_STANDALONE_MAP_WAIT_TIMEOUT (60*1000)
#define FMA_FMS_MAP_WAIT_TIMEOUT (300*1000)
#define FMA_MAP_DISTRIBUTION_TIMEOUT (45*1000)
#define FMA_MAP_GRACE_PERIOD (5*1000)
#define FMA_MAX_MAP_SENDS_PENDING 150

/*
 * Data specific to standalone mode
 */
struct fma_standalone_data {
  int active;				/* true if i am the "active" mapper */
  int my_level;

  /* This is true from the time that mapping starts until FMA_MAP_GRACE_PERIOD
   * after map distribution complete
   */
  int mapping_in_progress;
  struct lf_event *map_dist_timer;	/* timeout for global map distr. */
  struct lf_event *map_grace_timer;	/* timeout after map dist done */

  struct lf_event *map_wait_timer;	/* timer for waiting for a map */
  int map_request_msg_id;		/* msg ID of map request in progress */
};

/*
 * prototypes
 */
void fma_enter_standalone_mode(void);
void fma_cancel_standalone_mode(void);
void fma_exit_standalone_mode(void);
void fma_standalone_got_contact(int level, lf_mac_addr_t mac_addr,
	struct fma_nic_info *nic, int port, uint8_t *route, int route_len,
	enum fma_nic_scout_type pkt_type);
void fma_standalone_map_done(struct lf_topo_map *, int);
void fma_reset_mapping_done(void);
void fma_remote_map_dist_done(struct fma_dist_done_msg *msg,
  lf_mac_addr_t sender_mac);
